* Title: 	figure12.do
* Version: 	23 May 2018
* Purpose: 	Produce graph of trends in mortality by region


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure12, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use dta/cdc_mortality_clean, clear

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)


*******************************************************************************
* (2) Construct mortality rates for regions
*******************************************************************************

foreach var in deaths population {
	gen `var'_Coastal	= `var' if (RegionI == 0)
	gen `var'_EH		= `var' if (RegionI == 1)
	gen `var'_WH 		= `var' if (RegionI == 2)
}
drop deaths population

collapse (sum) deaths* population* , by(year)
	
tsset year
foreach region in Coastal EH WH {
	gen MortalityRate_`region' =  100 * (L.deaths_`region' + deaths_`region' + F.deaths_`region') ///
									  / (L.population_`region' + population_`region' + F.population_`region')
}

keep year MortalityRate_* 
keep if (year >= 1969 & year <= 2015)

* Save dataset
compress
save output/figures/dta/figure12.dta, replace


*******************************************************************************
* (3) Produce graph
*******************************************************************************

line 	MortalityRate_Coastal MortalityRate_EH MortalityRate_WH year, ///
		legend(label(1 "Coastal States") label(2 "Eastern Heartland") label(3 "Western Heartland")) ///
		graphregion(color(white)) bgcolor(white) ///
		xtitle("Year")  ytitle("Mortality Rate, percent")

graph save output/figures/gph/figure12, replace
graph export output/figures/eps/figure12.eps, as(eps) replace
export excel using output/figures/xlsx/figure12.xlsx, first(variables) replace


*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
